function AISMN_FadeOut::OnEnter(%this,%obj)
{
   %object = GetThisObject(%obj);
   if(%object.isServerObject())
   {
      %object.startFade(1000, 0, true);
      
      //Remove the object from selection on the client side
      %id = slgGetGhostIndex(%object);
      RemoveObjectFromSelection(%id);
      DisableCollision(%id);
   }
   return;
}

function AISMN_FadeOut::OnExit(%this,%obj)
{
   %object = GetThisObject(%obj);
   %object.showMesh(false);
   return;
}

function AISMN_FadeOut::Update(%this,%obj)
{
   %timePassed = TimeInNode(%obj);
   if(!GetThisObject(%obj).isFading() || %timePassed >= 1)
      ReturnValue(%obj,0);
   else
      ReturnValue(%obj,-1);
   return;
}
